/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.schedops.beans;

import com.ibm.hwmca.fw.schedops.DisplayData;
import com.ibm.hwmca.fw.tasklet.PanelBean;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.ui.framework.Capabilities;
import com.ibm.ui.framework.ColumnDescriptor;
import com.ibm.ui.framework.DataBean;
import com.ibm.ui.framework.IllegalUserDataException;
import com.ibm.ui.framework.ItemDescriptor;
import com.ibm.ui.framework.TaskActionEvent;
import java.io.Serializable;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;

public final class SchedOpsBean
extends PanelBean
implements DataBean {
    private static final String CLASS_NAME = "[SchedOpsBean] ";
    private static final String TRACE_MASKT = "XTIMxxxT";
    private static final String TRACE_MASKF = "XTIMxxxF";
    private static final String TRACE_MASKD = "XTIMxxxD";
    public static final String PARENT_CLOSING = "SaveButton";
    private static final String BY_DATE_MENU = "SortMenu.ByDateNTimeItem";
    private static final String BY_NAME_MENU = "SortMenu.ByObjectItem";
    private static final String BY_OPERATION_MENU = "SortMenu.ByOperationItem";
    private static final String CANCEL = "CANCEL";
    private static final String DELETE_MENU = "OptionsMenu.DeleteItem";
    private static final String DESELECT_ALL_MENU = "OptionsMenu.DeselectAllItem";
    private static final String DETAILS_MENU = "ViewMenu.SchedDetailsItem";
    private static final String DISPLAY_INFO = "DisplayInfoOutput";
    private static final String DOUBLE_CLICK = "ContextMenu1.DblClkItem";
    private static final String EXIT_MENU = "OptionsMenu.ExitItem";
    private static final String NEW_MENU = "OptionsMenu.NewItem";
    private static final String RANGE_MENU = "ViewMenu.NewTimeRangeItem";
    private static final String REFRESH_MENU = "OptionsMenu.RefreshItem";
    private static final String SELECT_ALL_MENU = "OptionsMenu.SelectAllItem";
    private static final String TABLE_NAME = "SchedOpsTable";
    private String m_sDisplayInfoOutput;
    private ItemDescriptor[] m_idSchedOpsTable;
    private ColumnDescriptor[] m_cdSchedOpsTableStructure;
    private int[] m_iSchedOpsTableSelection;
    private transient Comparator lastSortByPrimary = null;
    private transient Comparator lastSortBySecondary = null;
    private Lock inventoryLock = new Lock();
    private ArrayList inventory = new ArrayList();

    public SchedOpsBean(String name, ArrayList initialData, LocalizableText initialText) {
        Trace.trace(TRACE_MASKT, "[SchedOpsBean] >> SchedOpsBean() : Name = " + name);
        this.setBeanName(name);
        this.refreshInventory(initialData, initialText);
        Trace.trace(TRACE_MASKT, "[SchedOpsBean] << SchedOpsBean()");
    }

    public void prepare() {
        this.setMenuItemStates();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void panelAction(TaskActionEvent event) {
        Trace.trace(TRACE_MASKT, "[SchedOpsBean] >> panelAction() : \n   Bean Name     : " + this.getBeanName() + "\n   CurrentElement: " + event.getCurrentElement() + "\n   ElementName   : " + event.getElementName() + "\n   ActionCommand : " + event.getActionCommand());
        String elementName = event.getElementName();
        String actionCommand = event.getActionCommand();
        if (actionCommand.endsWith(NEW_MENU)) {
            this.sendTaskletRequest(actionCommand, null);
        } else if (actionCommand.endsWith(DELETE_MENU)) {
            int[] selected = this.getSchedOpsTableSelection();
            if (selected.length > 0) {
                ArrayList<Integer> list = new ArrayList<Integer>();
                Lock lock = this.inventoryLock;
                synchronized (lock) {
                    int i = 0;
                    while (i < selected.length) {
                        list.add(((DisplayData)this.inventory.get(selected[i])).getUniqueID());
                        ++i;
                    }
                }
                this.sendTaskletRequest(actionCommand, list);
            }
        } else if (actionCommand.endsWith(REFRESH_MENU)) {
            this.sendTaskletRequest(actionCommand, null);
        } else if (actionCommand.endsWith(SELECT_ALL_MENU)) {
            int[] selected = new int[this.getInventorySize()];
            int i = 0;
            while (i < selected.length) {
                selected[i] = i;
                ++i;
            }
            this.setSchedOpsTableSelection(selected);
            this.userTaskManager.refreshElement(this.getMountPrefix() + TABLE_NAME);
        } else if (actionCommand.endsWith(DESELECT_ALL_MENU)) {
            this.setSchedOpsTableSelection(new int[0]);
            this.userTaskManager.refreshElement(this.getMountPrefix() + TABLE_NAME);
        } else if (actionCommand.endsWith(EXIT_MENU)) {
            this.sendTaskletRequest(actionCommand, null);
        } else if (actionCommand.endsWith(DETAILS_MENU) || actionCommand.endsWith(DOUBLE_CLICK)) {
            int[] selected = this.getSchedOpsTableSelection();
            ArrayList<Integer> list = new ArrayList<Integer>();
            Lock lock = this.inventoryLock;
            synchronized (lock) {
                int i = 0;
                while (i < selected.length) {
                    list.add(((DisplayData)this.inventory.get(selected[i])).getUniqueID());
                    ++i;
                }
            }
            this.sendTaskletRequest(actionCommand, list);
        } else if (actionCommand.endsWith(RANGE_MENU)) {
            this.sendTaskletRequest(actionCommand, null);
        } else if (actionCommand.endsWith(BY_DATE_MENU)) {
            this.lastSortByPrimary = new SortByDate();
            this.lastSortBySecondary = new SortByName();
            Lock lock = this.inventoryLock;
            synchronized (lock) {
                Collections.sort(this.inventory, this.lastSortBySecondary);
                Collections.sort(this.inventory, this.lastSortByPrimary);
            }
            this.setSchedOpsTableSelection(new int[0]);
            this.userTaskManager.refreshElement(this.getMountPrefix() + TABLE_NAME);
        } else if (actionCommand.endsWith(BY_NAME_MENU)) {
            this.lastSortByPrimary = new SortByName();
            this.lastSortBySecondary = new SortByDate();
            Lock lock = this.inventoryLock;
            synchronized (lock) {
                Collections.sort(this.inventory, this.lastSortBySecondary);
                Collections.sort(this.inventory, this.lastSortByPrimary);
            }
            this.setSchedOpsTableSelection(new int[0]);
            this.userTaskManager.refreshElement(this.getMountPrefix() + TABLE_NAME);
        } else if (actionCommand.endsWith(BY_OPERATION_MENU)) {
            this.lastSortByPrimary = new SortByOperation();
            this.lastSortBySecondary = new SortByDate();
            Lock lock = this.inventoryLock;
            synchronized (lock) {
                Collections.sort(this.inventory, this.lastSortBySecondary);
                Collections.sort(this.inventory, this.lastSortByPrimary);
            }
            this.setSchedOpsTableSelection(new int[0]);
            this.userTaskManager.refreshElement(this.getMountPrefix() + TABLE_NAME);
        } else if (actionCommand.endsWith(CANCEL)) {
            this.sendTaskletRequest(actionCommand, null);
        } else {
            Trace.trace(TRACE_MASKT, "[SchedOpsBean]    Unknown event received ... ignored ... ");
        }
        Trace.trace(TRACE_MASKT, "[SchedOpsBean] << panelAction()");
    }

    public void update(Object object) {
        Trace.trace(TRACE_MASKT, "[SchedOpsBean] >> update()");
        if (object instanceof HashMap) {
            HashMap map = (HashMap)object;
            String cmd = (String)map.get("COMMAND");
            Trace.trace(TRACE_MASKF, "[SchedOpsBean] \tCommand = " + cmd);
            if (cmd.equals("REFRESH")) {
                this.refreshInventory((ArrayList)map.get("INVENTORY"), (LocalizableText)map.get("DISPLAY_INFO"));
                this.userTaskManager.refreshElement(this.getMountPrefix() + DISPLAY_INFO);
                this.setSchedOpsTableSelection(new int[0]);
                this.userTaskManager.refreshElement(this.getMountPrefix() + TABLE_NAME);
                this.setMenuItemStates();
            }
        }
        Trace.trace(TRACE_MASKT, "[SchedOpsBean] << update()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshInventory(ArrayList inventory, LocalizableText text) {
        Trace.trace(TRACE_MASKT, "[SchedOpsBean] >> refreshInventory() : " + this.getInventorySize());
        if (this.lastSortByPrimary == null) {
            this.lastSortByPrimary = new SortByName();
            this.lastSortBySecondary = new SortByDate();
        }
        Lock lock = this.inventoryLock;
        synchronized (lock) {
            this.inventory = inventory;
            Collections.sort(inventory, this.lastSortBySecondary);
            Collections.sort(inventory, this.lastSortByPrimary);
        }
        this.setSchedOpsTableSelection(new int[0]);
        this.setDisplayInfoOutput(text.toString());
        Trace.trace(TRACE_MASKT, "[SchedOpsBean] << refreshInventory() : " + this.getInventorySize());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setMenuItemStates() {
        Trace.trace(TRACE_MASKT, "[SchedOpsBean] >> setMenuItemStates()");
        if (this.userTaskManager != null) {
            String prefix = this.getMountPrefix();
            int[] selected = this.getSchedOpsTableSelection();
            int size = 0;
            Lock lock = this.inventoryLock;
            synchronized (lock) {
                size = this.getInventorySize();
            }
            Trace.trace(TRACE_MASKF, "[SchedOpsBean] \tSelected  = " + selected.length);
            Trace.trace(TRACE_MASKF, "[SchedOpsBean] \tInventory = " + size);
            this.userTaskManager.setEnabled(prefix + DETAILS_MENU, selected.length == 1);
            this.userTaskManager.setEnabled(prefix + DELETE_MENU, selected.length > 0);
            this.userTaskManager.setEnabled(prefix + DESELECT_ALL_MENU, selected.length > 0);
            this.userTaskManager.setEnabled(prefix + BY_DATE_MENU, size > 0);
            this.userTaskManager.setEnabled(prefix + BY_NAME_MENU, size > 0);
            this.userTaskManager.setEnabled(prefix + BY_OPERATION_MENU, size > 0);
            this.userTaskManager.setEnabled(prefix + SELECT_ALL_MENU, size > 0 && selected.length < size);
        }
        Trace.trace(TRACE_MASKT, "[SchedOpsBean] << setMenuItemStates()");
    }

    private void sendTaskletRequest(String actionCommand, Object data) {
        PanelTaskletRequest request = new PanelTaskletRequest(this.getBeanName() + '.' + actionCommand);
        request.setData("SOURCE", this.getBeanName());
        request.setData("ACTION", actionCommand);
        request.setData("DATA", data);
        this.postTaskletRequest(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getInventorySize() {
        int result = 0;
        Lock lock = this.inventoryLock;
        synchronized (lock) {
            result = this.inventory.size();
        }
        return result;
    }

    public int getSchedOpsTableRowCount() {
        return this.getInventorySize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ItemDescriptor[] getSchedOpsTableRowAt(int index) {
        DisplayData data = null;
        Lock lock = this.inventoryLock;
        synchronized (lock) {
            data = (DisplayData)this.inventory.get(index);
        }
        DateFormat dateFormat = DateFormat.getDateInstance(1);
        DateFormat timeFormat = DateFormat.getTimeInstance(1);
        String name = this.getMountPrefix() + "." + index;
        this.m_idSchedOpsTable = new ItemDescriptor[5];
        this.m_idSchedOpsTable[0] = new ItemDescriptor("Name" + name, data.getObjectName().toString());
        this.m_idSchedOpsTable[1] = new ItemDescriptor("Date" + name, dateFormat.format(data.getScheduledDate()));
        this.m_idSchedOpsTable[2] = new ItemDescriptor("Time" + name, timeFormat.format(data.getScheduledDate()));
        this.m_idSchedOpsTable[3] = new ItemDescriptor("Desc" + name, data.getOperationDescription().toString());
        String reps = data.getRemainingRepetitions() < 0L ? "Indefinite" : new Long(data.getRemainingRepetitions()).toString();
        this.m_idSchedOpsTable[4] = new ItemDescriptor("Reps" + name, reps);
        return this.m_idSchedOpsTable;
    }

    public void setSchedOpsTableSelection(int[] selected) throws IllegalUserDataException {
        Trace.trace(TRACE_MASKT, "[SchedOpsBean] <> setSchedOpsTableSelection() : " + selected.length);
        this.m_iSchedOpsTableSelection = selected;
        this.setMenuItemStates();
    }

    public String getDisplayInfoOutput() {
        return this.m_sDisplayInfoOutput;
    }

    public void setDisplayInfoOutput(String s) throws IllegalUserDataException {
        this.m_sDisplayInfoOutput = s;
    }

    public ColumnDescriptor[] getSchedOpsTableRowStructure() {
        return this.m_cdSchedOpsTableStructure;
    }

    public int getSchedOpsTableRowStatus() {
        return 3;
    }

    public void setSchedOpsTableRowAt(int index, ItemDescriptor[] items) throws IllegalUserDataException {
        this.m_idSchedOpsTable = items;
    }

    public int[] getSchedOpsTableSelection() {
        Trace.trace(TRACE_MASKT, "[SchedOpsBean] <> getSchedOpsTableSelection() : " + this.m_iSchedOpsTableSelection.length);
        return this.m_iSchedOpsTableSelection;
    }

    public Capabilities getCapabilities() {
        return null;
    }

    public void load() {
        this.m_idSchedOpsTable = new ItemDescriptor[0];
        this.m_cdSchedOpsTableStructure = new ColumnDescriptor[0];
        this.m_iSchedOpsTableSelection = new int[0];
    }

    public void verifyChanges() throws IllegalUserDataException {
    }

    public void save() {
    }

    private static class Lock
    implements Serializable {
    }

    private static class SortByDate
    implements Comparator {
        private SortByDate() {
        }

        public int compare(Object o1, Object o2) {
            int result = 0;
            if (!(o1 instanceof DisplayData) || !(o2 instanceof DisplayData)) {
                throw new ClassCastException("Incompatible classes");
            }
            result = ((DisplayData)o1).getScheduledDate().compareTo(((DisplayData)o2).getScheduledDate());
            return result;
        }

        public boolean equals(Object obj) {
            return obj instanceof SortByDate;
        }
    }

    private static class SortByOperation
    implements Comparator {
        private SortByOperation() {
        }

        public int compare(Object o1, Object o2) {
            int result = 0;
            if (!(o1 instanceof DisplayData) || !(o2 instanceof DisplayData)) {
                throw new ClassCastException("Incompatible classes");
            }
            result = ((DisplayData)o1).getOperationDescription().toString().compareTo(((DisplayData)o2).getOperationDescription().toString());
            return result;
        }

        public boolean equals(Object obj) {
            return obj instanceof SortByOperation;
        }
    }

    private static class SortByName
    implements Comparator {
        private SortByName() {
        }

        public int compare(Object o1, Object o2) {
            int result = 0;
            if (!(o1 instanceof DisplayData) || !(o2 instanceof DisplayData)) {
                throw new ClassCastException("Incompatible classes");
            }
            result = ((DisplayData)o1).getObjectName().toString().compareTo(((DisplayData)o2).getObjectName().toString());
            return result;
        }

        public boolean equals(Object obj) {
            return obj instanceof SortByName;
        }
    }
}

